IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[EpisodePatientExtendedDetailsGet]') AND type in (N'P', N'PC'))
BEGIN
	DROP PROCEDURE [hips].[EpisodePatientExtendedDetailsGet]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

-- =============================================

-- Create date:   17 Apr 2014
-- Description:   Gets an Episode for a patient in hospital with Patient and Consent.
-- 12/02/2016 Return details even if the associated responsible provider does not have an HospitalHealthProviderIndividual entry
-- =============================================
CREATE PROCEDURE [hips].[EpisodePatientExtendedDetailsGet]
    (
      @HospitalCodeSystem VARCHAR(20),
      @PatientId INT,
      @SourceSystemEpisodeId VARCHAR(100)
    )
AS 
    BEGIN

        SELECT  e.EpisodeId ,
				hp.Mrn ,
				pm.CurrentSexId,
				pm.DateOfBirth,
				pm.MedicareNumber,
				pm.MedicareIrn,
				pm.DvaNumber,
				pmn.FamilyName,
				pmn.GivenNames,
				pmnt.Description AS Title,
				pmns.Description AS Suffix,
				hc.Code as HospitalCode,
				h.HospitalId,
				h.Name as HospitalName,
				e.Ward,
				e.Room,
				e.Bed,
                e.AdmissionDate ,
                e.AdmissionReason , 
                e.DischargeDate ,
				rpi.PasProviderIdentifier AS ResponsibleProviderIdentifier,
                rp.FamilyName AS ResponsibleProviderFamilyName ,
                rp.GivenNames AS ResponsibleProviderGivenNames ,
                rpt.Description AS ResponsibleProviderTitle ,
                rps.Description AS ResponsibleProviderSuffix ,
                e.SourceSystemEpisodeId ,
                e.ConsentWithdrawn ,
                (SELECT TOP 1 ca.AuditInformation FROM hips.ConsentAudit ca WHERE e.EpisodeId = ca.EpisodeId ORDER BY ConsentAuditId DESC) AS WithdrawalAuditInformation
        FROM    hips.HospitalPatient hp
                INNER JOIN hips.Episode e ON hp.PatientId = e.PatientId
                INNER JOIN hips.HospitalCode hc	ON hp.HospitalId = hc.HospitalId	
					AND hc.CodeSystemId = (SELECT CodeSystemId FROM hips.CodeSystem WHERE Code = @HospitalCodeSystem)
				INNER JOIN hips.Hospital h ON hp.HospitalId = h.HospitalId
                INNER JOIN hips.HealthProviderIndividual rp ON e.ResponsibleProviderId = rp.HealthProviderIndividualId
				LEFT OUTER JOIN HIPS.HospitalHealthProviderIndividual rpi ON rp.HealthProviderIndividualId = rpi.HealthProviderIndividualId
                INNER JOIN hips.Title rpt ON rp.TitleId = rpt.TitleId
                INNER JOIN hips.Suffix rps ON rp.SuffixId = rps.SuffixId
                INNER JOIN hips.PatientMaster pm ON hp.PatientMasterId = pm.PatientMasterId
				INNER JOIN hips.PatientMasterName pmn ON pm.PatientMasterId = pmn.PatientMasterId AND pmn.NameTypeId = 2 -- Current Name
                LEFT JOIN hips.Title pmnt ON pmn.TitleId = pmnt.TitleId
				LEFT JOIN hips.Suffix pmns ON pmn.SuffixId = pmns.SuffixId
        WHERE   e.PatientId = @PatientId
		AND		e.SourceSystemEpisodeId = @SourceSystemEpisodeId

     END


GO
GRANT EXEC ON [hips].[EpisodePatientExtendedDetailsGet] TO RunStoredProcedure
GO
